<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::redirect('/','/login');

Auth::routes();

Route::middleware(['auth'])->group(function(){

	Route::post('saveInvoice','Api\PosController@saveInvoice');

	Route::get('create-invoice','HomeController@create_invoice_new');

	Route::get('/home', 'HomeController@index')->name('home');

	Route::get('dashboard','HomeController@dashboard');
	Route::get('/graph-report-new', 'HomeController@makeNewGraphRpt');

	//point of sale
	Route::resource('pos/create-invoice','Pos\PosController');
	Route::post('insertPosInvoicedata', 'Pos\PosController@InsertPosInvoice')->name('insertPosInvoicedata');

	//ajax call releated route
	Route::get('/checkuserName/', 'AjaxController@checkuserName')->name('checkuserName');

	//category
	Route::get('itemWiseCategorys/', 'AjaxController@catWiseItemAlls')->name('itemWiseCategorys');
	Route::get('/itemWiseCategory/', 'AjaxController@catWiseItemAll')->name('itemWiseCategory');

	//product
	Route::resource('products','Admin\ProductController');
	Route::get('product/{id}/delete','Admin\ProductController@destroy');
	Route::get('download','Admin\ProductController@download');
	Route::get('download_daily_stock_import','Admin\ProductController@downloadDailyStockImport');
	Route::post('products-update','Admin\ProductController@update');
	Route::post('products-sort-update','Admin\ProductController@productsSortUpdate');


	Route::get('/productIdSearch/', 'AjaxController@ProductId')->name('productIdSearch');
	Route::get('/ProductWiseearch/', 'AjaxController@ProductSearchRecall')->name('ProductWiseearch');
	Route::get('get_sub_category_by_category_id','AjaxController@get_sub_category_by_category_id');

	Route::get('productSearchByName','AjaxController@productSearchByName')->name('productSearchByName');
	//item
	Route::get('/settelItem/', 'AjaxController@settelItemList')->name('settelItem');
	Route::get('/remove-product-id-hold/', 'AjaxController@removeProIdFrmHold')->name('remove-product-id-hold');
	Route::get('/remove-product-id-draft/', 'AjaxController@removeProId')->name('remove-product-id-draft');
	Route::get('/clearAll/', 'AjaxController@ClearAll')->name('clearAll');
	Route::get('/showRe-call-Item/', 'AjaxController@ShowReCallItem')->name('showRe-call-Item');
	Route::get('/insertHoldInvoicedata', 'AjaxController@InsertHoldInvoice')->name('insertHoldInvoicedata');
	Route::get('/holdlist/', 'AjaxController@holdlist')->name('holdlist');

	//Users Releated
	Route::resource('users','Admin\UserController');
	Route::post('users-update','Admin\UserController@update');
	
	//outlets Releated
	Route::resource('outlets','Admin\OutletController');
	Route::post('outlets-update','Admin\OutletController@update');

	//categories Releated
	Route::resource('categories','Admin\CategotyController');
	Route::post('categories-update','Admin\CategotyController@update');

	// outlets daily stream_socket_accept
	Route::resource('admin/outlets-daily-stock','Admin\OutletDailyStockController');
	Route::post('admin/outlets-daily-stock-update','Admin\OutletDailyStockController@update');

	Route::post('admin/upload-daily-stock-file','Admin\OutletDailyStockController@uploadDailyStockFile');


	//salse releated route
	Route::get('admin/create-invoice','Admin\SalesController@create_invoice');
	Route::get('re-print-invoice','Admin\SalesController@rePrintInvoice')->name('re-print-invoice');


	Route::post('get-product-data-by-item-name','Admin\SalesController@get_product_data_by_item_name');

	Route::post('get_product_info','Api\PosController@getProductInfo');

	// Order details
	Route::resource('admin/orders','Admin\OrderController');
	Route::get('admin/order-details/{id}','Admin\OrderController@order_details');
	// Route::post('admin/outlets-daily-stock-update','Admin\OrderController@update');

	//report releated route
	Route::get('admin/reports','Admin\ReportController@index');
	Route::get('admin/report/sales-report','Admin\ReportController@sales_report');
	Route::get('admin/report/revenue-report','Admin\ReportController@revenue_report');

	
	//sub-categories Releated
	Route::resource('admin/sub-categories','Admin\SubCategortController');
	Route::post('admin/sub-categories-update','Admin\SubCategortController@update');
	Route::get('api/get-user','HomeController@get_user');
	

});