@extends('admin.master')
@section('title', $title)
@section('maincontent')
<style type="text/css">
    .required{
        color: red;
        font-weight: 600;
    }
</style>

<div class="content-wrapper">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">{{ $title }} List</h5>
                        <button class="btn btn-info btn-sm" style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add New</button>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Sub Category Name</th>
                                    <th>Category Name</th>
                                    <th>Slug</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($sub_categories as $key => $list)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $list->sub_cat_name }}</td>
                                    <td>{{ $list->category->category_name }}</td>
                                    <td>{{ $list->slug }}</td>
                                    <td>
                                        @if($list->status == 1)
                                        <button class="btn btn-success btn-sm">Active</button>
                                        @else
                                        <button class="btn btn-danger btn-sm">In Active</button>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-primary btn-sm" onclick="editData({{json_encode($list)}})"><i class="fa fa-edit"></i></button>
                                        <button class="btn btn-danger waves-effect btn-sm" onclick="return deleteCertification(<?php echo $list->sub_cat_id ; ?>)"><i style="font-size: 15px;" class="fa fa-trash"></i></button>
                                        <form id="delete-form-{{$list->sub_cat_id }}" action="{{url('admin/sub-categories',$list->sub_cat_id )}}" method="post" style="display: none;">
                                            @method('DELETE')
                                            @csrf
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="paginate">
                            {!! $sub_categories->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!--End Row-->
    <div class="overlay toggle-menu"></div>

    <div class="modal fade" id="addModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fa fa-star"></i>Add {{ $title }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="{{ url('admin/sub-categories') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Name <span class="required">*</span></label>
                            <input type="text" class="form-control" name="name" placeholder="Enter Product Name" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Category <span class="required">*</span></label>
                            <select name="category" class="form-control" required="">
                                <option value="">Select Category</option>
                                @foreach($categories as $cat)
                                <option value="{{ $cat->category_id }}">{{ $cat->category_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Status <span class="required">*</span></label>
                            <select class="form-control" name="status" required="">
                                <option value="">Select Status</option>
                                <option value="1">Active</option>
                                <option value="2">InActive</option>
                            </select>
                        </div>
                    </div>  
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                    </div>
                </div>
            </form>
      </div>
    </div>

    {{-- edit Data --}}
    <div class="modal fade" id="editModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fa fa-star"></i>Update {{ $title }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="{{ url('admin/sub-categories-update') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Name <span class="required">*</span></label>
                            <input type="text" id="name" class="form-control" name="name" placeholder="Enter Product Name" required>
                        </div>

                        <div class="form-group">
                            <label>Category <span class="required">*</span></label>
                            <select name="category" id="category" class="form-control" required="">
                                <option value="">Select Category</option>
                                @foreach($categories as $cat)
                                <option value="{{ $cat->category_id }}">{{ $cat->category_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Status <span class="required">*</span></label>
                            <select class="form-control" id="status" name="status" required="">
                                <option value="">Select Status</option>
                                <option value="1">Active</option>
                                <option value="2">InActive</option>
                            </select>
                        </div>
                    </div>
                    <input type="hidden" name="sub_cat_id" id="sub_cat_id">
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                    </div>
                </div>
            </form>
      </div>
    </div>
    <!--end overlay-->
</div>
<!-- End container-fluid-->

@endsection

@push('js')

<script type="text/javascript">

    function editData(value){
        $('#editModal').modal('show')
        $('#sub_cat_id').val(value.sub_cat_id)
        $('#name').val(value.sub_cat_name)
        $('#category').val(value.category_id)
        $('#status').val(value.status)
    }

</script>
@endpush