@extends('admin.master')
@section('title', $title)
@push('css')
<style type="text/css">
    .required{
        color: red;
        font-weight: 600;
    }
</style>
@endpush
@section('maincontent')


<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">{{ $title }} List</h5>
                            <button class="btn btn-info btn-sm" style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add New</button>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Slug</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($categories as $key => $list)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $list->category_name }}</td>
                                        <td>{{ $list->slug }}</td>
                                        <td>
                                            @if($list->status == 1)
                                            <button class="btn btn-success btn-sm">Active</button>
                                            @else
                                            <button class="btn btn-danger btn-sm">In Active</button>
                                            @endif
                                        </td>
                                        <td>
                                            <button class="btn btn-primary btn-sm" onclick="editData({{json_encode($list)}})"><i class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger waves-effect btn-sm" onclick="return deleteCertification(<?php echo $list->category_id ; ?>)"><i style="font-size: 15px;" class="fa fa-trash"></i></button>
                                            <form id="delete-form-{{$list->category_id }}" action="{{url('categories',$list->category_id )}}" method="post" style="display: none;">
                                                @method('DELETE')
                                                @csrf
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="paginate">
                                {!! $categories->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--End Row-->
        <div class="overlay toggle-menu"></div>

        <div class="modal fade" id="addModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Add {{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('categories') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Product Name" required>
                            </div>
                            <label>Button Color</label><br>
                            <div class="form-check form-check-inline">
                                <div class="icheck-primary">
                                    <input type="radio" id="edit_primary" name="btn_color" required value="btn btn-primary">
                                    <label for="edit_primary"><span class="btn btn-primary btn-sm">Primary</span></label>
                                </div>
                            </div>
                            <div class="form-check form-check-inline">
                                <div class="icheck-warning">
                                    <input type="radio" id="edit_warning" name="btn_color" required value="btn btn-warning">
                                    <label for="edit_warning"><span class="btn btn-warning btn-sm">Warning</span></label>
                                </div>
                            </div>
                            
                            <div class="form-check form-check-inline">
                                <div class="icheck-success">
                                    <input type="radio" id="edit_success" name="btn_color" required value="btn btn-success">
                                    <label for="edit_success"><span class="btn btn-success btn-sm">Success</span></label>
                                </div>
                            </div>

                            <div class="form-check form-check-inline">
                                <div class="icheck-danger">
                                    <input type="radio" id="edit_danger1" name="btn_color" required value="btn btn-danger">
                                    <label for="edit_danger1"><span class="btn btn-danger btn-sm">danger</span></label>
                                </div>
                            </div>

                            <div class="form-check form-check-inline">
                                <div class="icheck-info">
                                    <input type="radio" id="edit_info" name="btn_color" required value="btn btn-info">
                                    <label for="edit_info"><span class="btn btn-info btn-sm">info</span></label>
                                </div>
                            </div>
                            <div class="form-check form-check-inline">
                                <div class="icheck-default">
                                    <input type="radio" id="edit_secondary2" name="btn_color" required value="btn btn-default">
                                    <label for="edit_secondary2"><span class="btn btn-secondary btn-sm">secondary</span></label>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Status <span class="required">*</span></label>
                                <select class="form-control" name="status" required="">
                                    <option value="">Select Status</option>
                                    <option value="1">Active</option>
                                    <option value="2">InActive</option>
                                </select>
                            </div>
                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>

        {{-- edit Data --}}
        <div class="modal fade" id="editModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Update {{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('categories-update') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Name <span class="required">*</span></label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Product Name" required>
                            </div>
                            <label>Button Color</label><br>
                            <div class="form-check form-check-inline">
                                <div class="icheck-primary">
                                    <input type="radio" id="primary" name="btn_color" required value="btn btn-primary">
                                    <label for="primary"><span class="btn btn-primary btn-sm">Primary</span></label>
                                </div>
                            </div>
                            <div class="form-check form-check-inline">
                                <div class="icheck-warning">
                                    <input type="radio" id="warning" name="btn_color" required value="btn btn-warning">
                                    <label for="warning"><span class="btn btn-warning btn-sm">Warning</span></label>
                                </div>
                            </div>
                            
                            <div class="form-check form-check-inline">
                                <div class="icheck-success">
                                    <input type="radio" id="success" name="btn_color" required value="btn btn-success">
                                    <label for="success"><span class="btn btn-success btn-sm">Success</span></label>
                                </div>
                            </div>

                            <div class="form-check form-check-inline">
                                <div class="icheck-danger">
                                    <input type="radio" id="danger1" name="btn_color" required value="btn btn-danger">
                                    <label for="danger1"><span class="btn btn-danger btn-sm">danger</span></label>
                                </div>
                            </div>

                            <div class="form-check form-check-inline">
                                <div class="icheck-info">
                                    <input type="radio" id="info" name="btn_color" required value="btn btn-info">
                                    <label for="info"><span class="btn btn-info btn-sm">info</span></label>
                                </div>
                            </div>
                            <div class="form-check form-check-inline">
                                <div class="icheck-default">
                                    <input type="radio" id="secondary2" name="btn_color" required value="btn btn-default">
                                    <label for="secondary2"><span class="btn btn-secondary btn-sm">secondary</span></label>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Status <span class="required">*</span></label>
                                <select class="form-control" name="status" required="">
                                    <option value="">Select Status</option>
                                    <option value="1">Active</option>
                                    <option value="2">InActive</option>
                                </select>
                            </div>
                        </div>
                        <input type="hidden" name="category_id" id="category_id">
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>
        <!--end overlay-->
    </div>
</div>
<!-- End container-fluid-->

@endsection

@push('js')

<script type="text/javascript">

    function editData(value){
        $('#editModal').modal('show')

        $('input[name="btn_color"]').each(function () {
            if($(this).is(':checked')){
                console.log('work')
            }
        });


        $('#category_id').val(value.category_id)
        $('#name').val(value.name)
        $('#btn_color').val(value.btn_color)
        $('#status').val(value.status)
    }

</script>
@endpush