<?php $__env->startSection('title', $title); ?>
<?php $__env->startPush('css'); ?>
    <link href="<?php echo e(asset('admin/assets/plugins/bootstrap-datatable/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('admin/assets/plugins/bootstrap-datatable/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css">
    <style type="text/css">
        .card .table td, .card .table th{
            padding: 4px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('maincontent'); ?>

<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">            
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                    <div class="search" style="padding-bottom: 50px;"> 
                        <form method="GET" action="<?php echo e(url('products')); ?>">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div id="dateragne-picker">
                                            <div class="input-group">
                                                <input type="text" class="form-control" value="<?php echo e($search_product); ?>" name="product" placeholder="Search Product" />    
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 form-inline">
                                        <button type="submit" class="btn btn-success"><i class="fa fa-search"></i></button>
                                    </div>
                                </div>
                        </form> 
                    </div>                     
                        <h5 class="card-title"><?php echo e($title); ?> List</h5>
                        <div >
                            <a href="<?php echo e(url('download')); ?>">
                                <button class="btn btn-info" style="margin:-45px 0px 0px 250px; float: left;">Download Products</button>
                            </a>
                        </div>
                        <div style="margin-right:135px;" >
                            <a href="<?php echo e(url('download_daily_stock_import')); ?>">
                                <button class="btn btn-info" style="margin:-45px 0px 0px 250px; float: right;">Download Stock Import</button>
                            </a>
                        </div>
                        <div>
                            <button class="btn btn-info " style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add New</button>
                        </div>
                        
                        <div class="table-responsive">
                            
                                <table class="table table-bordered table-striped" id="dataTables">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Category</th>
                                            <th>Product Name</th>
                                            <th>Sort/Serial</th>
                                            <th>Code</th>
                                            <th>Regular Price</th>
                                            <th>Special Price</th>
                                            <th>Factory Price</th>
                                            <th>Price/Pc</th>
                                            <th>Weight/Pc(gm)</th>
                                            <th>Status</th>
                                            <th>Photo</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e($list->category->category_name); ?></td>
                                            <td><?php echo e($list->product_name); ?></td>
                                            <td>   
                                                <input style="width: 80px; text-align: center" type="number" name="sort<?php echo e($list->product_id); ?>" value="<?php echo e($list->sort); ?>">
                                                <input type="hidden" name="product_ids[]" value="<?php echo e($list->product_id); ?>">
                                            </td>
                                            <td><?php echo e($list->product_code); ?></td>
                                            <td><?php echo e($list->regular_price); ?> / <?php echo e($list->base_unit); ?></td>
                                            <td><?php echo e($list->special_price); ?></td>
                                            <td><?php echo e($list->orginal_price); ?></td>
                                            <td><?php echo e($list->price_perpc); ?></td>
                                            <td><?php echo e($list->weight_perpc); ?></td>
                                            <td>
                                                <?php if($list->status == 1): ?>
                                                <button class="btn btn-success btn-sm">Active</button>
                                                <?php else: ?>
                                                <button class="btn btn-danger btn-sm">In Active</button>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <img src="<?php echo e(asset('admin/'.$list->photo)); ?>" width="70">
                                            </td>
                                            <td>
                                                <button class="btn btn-primary btn-sm" onclick="editData(<?php echo e(json_encode($list)); ?>)"><i class="fa fa-edit"></i></button>
                                               <button class="btn btn-danger waves-effect btn-sm" onclick="return deleteCertification(<?php echo $list->product_id  ; ?>)"><i style="font-size: 15px;" class="fa fa-trash"></i></button>
                                                <form id="delete-form-<?php echo e($list->product_id); ?>" action="<?php echo e(url('products',$list->product_id  )); ?>" method="post" style="display: none;">
                                                    <?php echo method_field('DELETE'); ?>
                                                    <?php echo csrf_field(); ?>
                                                </form>
                                                
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                            </td>
                                            <td>
                                            </td>
                                            <td>
                                            </td>
                                            <td  colspan="11">
                                                <button onclick="updateSortValue()" class="btn btn-primary waves-effect btn-sm" >Save Changes</button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table> 
                            
                            <div class="paginate" style="float: right;">
                                <?php echo e($products->appends(Request::except('page'))->links()); ?>

                            </div>                         
                        </div>
                    </div>
                </div>
            </div>
        </div><!--End Row-->
        <div class="overlay toggle-menu"></div>

        <div class="modal fade" id="addModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Add <?php echo e($title); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="<?php echo e(url('products')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">

                            <div class="form-group">
                                <label>Category <span class="required"></span></label>
                                <select class="form-control select2" name="category" required>
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat_data->category_id); ?>"><?php echo e($cat_data->category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                           
                            <div class="row">
                                <div class="form-group col">
                                    <label>Name <span class="required"></span></label>
                                    <input type="text" class="form-control" name="name" placeholder="Enter Product Name" required>
                                </div>
                                <div class="form-group col">
                                    <label>Code <span class="required"></span></label>
                                    <input type="text" class="form-control" name="code" placeholder="Enter Product Code" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Base Unit  <span class="required"></span></label>
                                <select class="form-control select2 base_unit" name="base_unit" required>
                                    <option value="">Select Unit</option>
                                    <option value="Kg">Kg</option>
                                    <option value="Pc">Pc</option>
                                </select>
                            </div>
                            <div class="row">                                
                                <div class="form-group col">
                                    <label id="regular_price_label">Regular Price (<small>MRP Price</small>) <span class="required"></span></label>
                                    <input type="number" step="any" class="form-control" name="regular_price" placeholder="Enter Regular Price" required>
                                </div>
                                <div class="form-group col">
                                    <label>Special Price</label>
                                    <input type="number" step="any" class="form-control" name="special_price" placeholder="Enter Special Price">
                                </div>
                            </div>                            
                            <div class="row">
                                <div class="form-group col">
                                    <label>Original Price (<small>Factory Price</small>)</label>
                                    <input type="number" step="any" class="form-control" name="original_price" placeholder="Enter Original Price">
                                </div>
                                <div class="form-group col">
                                    <label>Status <span class="required"></span></label>
                                    <select name="status" class="form-control" required="">
                                        <option value="">Select Status</option>
                                        <option value="1">Active</option>
                                        <option value="2">In Active</option>
                                    </select>
                                </div>
                            </div>                           
                            <div class="row price_perpc" style="display: none;">
                                <div class="form-group col">
                                    <label>Price/Pc (<small>MRP Price</small>) <span class="required"></span></label>
                                    <input type="number" step="any" class="form-control" name="price_perpc" placeholder="Enter Price/Pc">
                                </div>
                                <div class="form-group col">
                                    <label>Weight/Pc(gm)</label>
                                    <input type="number" step="any" class="form-control" name="weight_perpc" placeholder="Enter Weight Per/Pc">
                                </div>                               
                            </div>
                            <div class="row price_perpc" style="display: none;">
                                <div class="form-group col">
                                    <label>Original Price/Pc (<small>Factory Price</small>)</label>
                                    <input type="number" step="any" class="form-control" name="original_price_perpc" placeholder="Enter Original Price/Pc">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Image</label>
                                <input type="file" class="form-control" name="image">
                            </div>
                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>

        
        <div class="modal fade" id="editModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Update <?php echo e($title); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="<?php echo e(url('products-update')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Category <span class="required"></span></label>
                                <select class="form-control" id="category" name="category" onchange="getSubCat(this.value)" required>
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat_data->category_id); ?>"><?php echo e($cat_data->category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                           
                            <div class="row">
                                <div class="form-group col">
                                    <label>Name <span class="required"></span></label>
                                    <input type="text" class="form-control" name="name" id="name" placeholder="Enter Product Name" required>
                                </div>
                                <div class="form-group col">
                                    <label>Code <span class="required"></span></label>
                                    <input type="text" class="form-control" id="code" name="code" placeholder="Enter Product Code" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Base Unit  <span class="required"></span></label>
                                <select class="form-control select2 base_unit_edit" name="base_unit" id="base_unit" required>
                                    <option value="">Select Unit</option>
                                    <option value="Kg">Kg</option>
                                    <option value="Pc">Pc</option>
                                </select>
                            </div>
                            <div class="row">
                                <div class="form-group col">
                                    <label id="regular_price_label_edit">Regular Price (<small>MRP Price</small>)<span class="required"></span></label>
                                    <input type="number" step="any" class="form-control" id="regular_price" name="regular_price" placeholder="Enter Regular Price" required>
                                </div>
                                <div class="form-group col">
                                    <label>Special Price</label>
                                    <input type="number" class="form-control" step="any" id="special_price" name="special_price" placeholder="Enter Special Price">
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="form-group col">
                                    <label>Original Price (<small>Factory Price</small>)</label>
                                    <input type="number" class="form-control" step="any" id="orginal_price" name="original_price" placeholder="Enter Original Price">
                                </div>
                                <div class="form-group col">
                                    <label>Status <span class="required"></span></label>
                                    <select name="status" class="form-control" id="status" required="">
                                        <option value="">Select Status</option>
                                        <option value="1">Active</option>
                                        <option value="2">In Active</option>
                                    </select>
                                </div>
                            </div>                            
                            <div class="row price_perpc_edit" style="display: none;">
                                <div class="form-group col">
                                    <label>Price/Pc (<small>MRP Price</small>) <span class="required"></span></label>
                                    <input type="number" step="any" class="form-control" name="price_perpc" id="price_perpc" placeholder="Enter Price/Pc" >
                                </div>
                                <div class="form-group col">
                                    <label>Weight/Pc(gm)</label>
                                    <input type="number" step="any" class="form-control" name="weight_perpc" id="weight_perpc" placeholder="Enter Weight Per/Pc">
                                </div>             
                            </div>
                            <div class="row price_perpc_edit" style="display: none;">
                                <div class="form-group col">
                                    <label>Original Price/Pc (<small>Factory Price</small>)</label>
                                    <input type="number" step="any" class="form-control" name="original_price_perpc" id="original_price_perpc" placeholder="Enter Original Price/Pc">
                                </div>
                            </div>
                            <div class="form-group">
                                <img src="" id="image" width="80">
                                <br>
                                <label>Image</label>
                                <input type="file" class="form-control" name="image">
                            </div>
                            <input type="hidden" name="product_id" id="product_id">
                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>
    </div>
    <!--end overlay-->
</div>
<!-- End container-fluid-->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('admin/assets/plugins/bootstrap-datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/plugins/bootstrap-datatable/js/dataTables.bootstrap4.min.js')); ?>"></script>

<script type="text/javascript">
    $( ".base_unit" ).change(function() {        
        var base_unit = $('.base_unit').find(":selected").val();
        if(base_unit=="Kg"){
            $('#regular_price_label').text('REGULAR PRICE / Kg (MRP PRICE)');
            $('.price_perpc').show();
        }if(base_unit=="Pc"){
            $('#regular_price_label').text('REGULAR PRICE (MRP PRICE)');
            $('.price_perpc').hide();            
        }        
    });
    $( ".base_unit_edit" ).change(function() {        
        var base_unit = $('.base_unit_edit').find(":selected").val();
        if(base_unit=="Kg"){
            $('#regular_price_label_edit').text('REGULAR PRICE / Kg (MRP PRICE)');
            $('.price_perpc_edit').show();
        }if(base_unit=="Pc"){
            $('#regular_price_label_edit').text('REGULAR PRICE (MRP PRICE)');
            $('.price_perpc_edit').hide();            
        }        
    });

    $(document).ready(function(){
        $('#dataTables').DataTable();
        $('.select2').select2();
    });

    function updateSortValue(){        
        var textValue = $("input[name='product_ids[]']").val();
        var jsonObj = [];
        $('input[name="product_ids[]"]').each(function() { 
            var product_id = $(this).val();
            var param = 'sort'+product_id;
            var sortValue = $('input[name='+param+']').val();

            product_sort = {}
            product_sort ["product_id"] = product_id;
            product_sort ["sort"] = sortValue;
            jsonObj.push(product_sort);
        });
        $.ajax({
            type: "post",
            url: '/products-sort-update',
            data: {
                "_token": "<?php echo e(csrf_token()); ?>",
                product_sort_data: jsonObj,
            },
            success: function(response) {
                if(response.success){
                    location.reload();
                    alert(response.success);                    
                }else{
                    alert(response.message)
                }
            }
        });       
    }

    function editData(value){
        // getSubCat(value.category_id)
        $('#editModal').modal('show')
        $('#category').val(value.category_id)
        $('#base_unit').val(value.base_unit)        
        // $('#sub_category').val(value.sub_cat_id)
        $('#name').val(value.product_name)
        $('#code').val(value.product_code)
        $('#regular_price').val(value.regular_price)
        $('#special_price').val(value.special_price)
        $('#orginal_price').val(value.orginal_price)
        $('#per_kg_price').val(value.per_kg_price)
        $('#product_id').val(value.product_id)
        $('#image').attr('src', BASE_URL+'/admin/'+value.photo)
        $('#status').val(value.status)
        if(value.base_unit=="Kg"){
            $('#regular_price_label_edit').text('REGULAR PRICE / Kg (MRP PRICE)');
            $('#price_perpc').val(value.price_perpc);
            $('#weight_perpc').val(value.weight_perpc);
            $('#original_price_perpc').val(value.original_price_perpc);           
            $('.price_perpc_edit').show();
        }else if(value.base_unit=="Pc"){
            $('#regular_price_label_edit').text('REGULAR PRICE(MRP PRICE)');
            $('#price_perpc').val('')
            $('#weight_perpc').val('')
            $('.price_perpc_edit').hide();
        }
    }

</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/posVueJs/resources/views/admin/pages/products.blade.php ENDPATH**/ ?>