@extends('admin.master')
@section('title', $title)
@section('maincontent')
<div class="content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">{{ $title }} List</h5>
                            <button class="btn btn-info btn-sm" style="margin-top: -45px; float: right;" data-toggle="modal" data-target="#addModal"><i class="fa fa-plus"></i> Add New</button>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>User Name</th>
                                        <th>Password</th>
                                        <th>Role</th>
                                        <th>Status</th>
                                        <th>Photo</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($users as $key => $list)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $list->name }}</td>
                                        <td>{{ $list->email }}</td>
                                        <td>{{ $list->username }}</td>
                                        <td>{{ $list->temp_password }}</td>
                                        <td>
                                            @if($list->role == 1)
                                            Admin
                                            @elseif($list->role == 2)
                                            Outlet Admin
                                            @elseif($list->role == 3)
                                            Sales Person
                                            @else
                                            Not Define
                                            @endif
                                        </td>
                                        <td>
                                            @if($list->status == 1)
                                            <button class="btn btn-success btn-sm">Active</button>
                                            @else
                                            <button class="btn btn-danger btn-sm">In Active</button>
                                            @endif
                                        </td>
                                        <td>
                                            <img src="{{ asset('storage/uploads/'.$list->photo) }}" width="70">
                                        </td>
                                        <td>
                                            <button class="btn btn-primary btn-sm" onclick="editData({{json_encode($list)}})"><i class="fa fa-edit"></i></button>
                                            <button class="btn btn-danger waves-effect btn-sm" onclick="return deleteCertification(<?php echo $list->id  ; ?>)"><i style="font-size: 15px;" class="fa fa-trash"></i></button>
                                            <form id="delete-form-{{$list->id  }}" action="{{url('users',$list->id  )}}" method="post" style="display: none;">
                                                @method('DELETE')
                                                @csrf
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="paginate" style="float: right; margin-top: 10px;">
                                {!! $users->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--End Row-->
        <div class="overlay toggle-menu"></div>

        <div class="modal fade" id="addModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Add {{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('users') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                           
                            <div class="row">
                                <div class="form-group col">
                                    <label>Name <span class="required"></span></label>
                                    <input type="text" class="form-control" name="name" placeholder="Enter User Name" required>
                                </div>
                                <div class="form-group col">
                                    <label>Email <span class="required"></span></label>
                                    <input type="email" class="form-control" name="email" placeholder="Enter Email" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col">
                                    <label>User Name <span class="required"></span></label>
                                    <input type="text" class="form-control" name="username" placeholder="Enter User Name" required>
                                </div>
                                <div class="form-group col">
                                    <label>Password</label>
                                    <input type="password" class="form-control" name="password" placeholder="Enter Password">
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col">
                                    <label>Role <span class="required"></span></label>
                                    <select name="role" onchange="roleChange(this.value)" class="form-control" required="">
                                        <option value="">Select Role</option>
                                        @foreach($roles as $role)
                                        <option value="{{ $role->role_id }}">{{ $role->role_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col">
                                    <label>Status <span class="required"></span></label>
                                    <select name="status" class="form-control" required="">
                                        <option value="">Select Status</option>
                                        <option value="1">Active</option>
                                        <option value="2">In Active</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group outlet_name">
                                <label>Outlets Name <span class="required"></span></label>
                                <select name="outlet_id" class="form-control outlet_id">
                                    <option value="">Select Outlet</option>
                                    @foreach($outlets as $outlet)
                                    <option value="{{ $outlet->id }}">{{ $outlet->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Image</label>
                                <input type="file" class="form-control" name="image">
                            </div>

                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>

        {{-- edit Data --}}
        <div class="modal fade" id="editModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-star"></i>Update {{ $title }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('users-update') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">

                            <div class="row">
                                <div class="form-group col">
                                    <label>Name <span class="required"></span></label>
                                    <input type="text" id="name" class="form-control" name="name" placeholder="Enter User Name" required>
                                </div>
                                <div class="form-group col">
                                    <label>Email <span class="required"></span></label>
                                    <input type="email" id="email" class="form-control" name="email" placeholder="Enter Email" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col">
                                    <label>User Name <span class="required"></span></label>
                                    <input type="text" id="username" class="form-control" name="username" placeholder="Enter User Name" required>
                                </div>
                                <div class="form-group col">
                                    <label>Password</label>
                                    <input type="password" id="password" class="form-control" name="password" placeholder="Enter Password">
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col">
                                    <label>Role <span class="required"></span></label>
                                    <select name="role" id="role" class="form-control" required="">
                                        <option value="">Select Role</option>
                                        @foreach($roles as $role)
                                        <option value="{{ $role->role_id }}">{{ $role->role_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col">
                                    <label>Status <span class="required"></span></label>
                                    <select name="status" id="status" class="form-control" required="">
                                        <option value="">Select Status</option>
                                        <option value="1">Active</option>
                                        <option value="2">In Active</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-group outlet_name">
                                <label>Outlets Name <span class="required"></span></label>
                                <select name="outlet_id" id="outlet_id" class="form-control outlet_id">
                                    <option value="">Select Outlet</option>
                                    @foreach($outlets as $outlet)
                                    <option value="{{ $outlet->id }}">{{ $outlet->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <img src="" id="image" width="60">
                                <br>
                                <label>Image</label>
                                <input type="file" class="form-control" name="image">
                            </div>

                            <input type="hidden" name="user_id" id="user_id">
                        </div>  
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-check-square-o"></i> Save changes</button>
                        </div>
                    </div>
                </form>
          </div>
        </div>
        <!--end overlay-->
    </div>
</div>
<!-- End container-fluid-->

@endsection

@push('js')

<script type="text/javascript">
    $(document).ready(function(){
        $('.outlet_name').hide()
        $('.outlet_id').attr('required', false)
    });

    function roleChange(value){
        if(value){
            if(value == 1){
                $('.outlet_name').hide()
                $('.outlet_id').attr('required', false)
            }else{
                $('.outlet_name').show()
                $('.outlet_id').attr('required', true)
            }
        }else{
            $('.outlet_name').hide()
            $('.outlet_id').attr('required', false)
        }
    }

    function editData(value){
        $('#editModal').modal('show')
        $('#name').val(value.name)
        $('#email').val(value.email)
        $('#username').val(value.username)
        $('#password').val(value.temp_password)
        $('#role').val(value.role)
        $('#outlet_id').val(value.outlet_id)        
        $('#status').val(value.status)
        $('#user_id').val(value.id)
        $('#image').attr('src', BASE_URL+'/storage/uploads/'+value.photo)
        roleChange(value.role)
    }

</script>
@endpush