<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    protected $table = 'tbl_subcategory';
    protected $primaryKey = 'sub_cat_id';
    public $timestamps = false;


    public function setSubCatNameAttribute($value){
        $this->attributes['sub_cat_name'] = $value;
        $this->attributes['slug'] = $this->slugify($value);
    }

    private function slugify($value){
        $slug = str_replace(' ', '-', strtolower($value));
        $count = SubCategory::where('slug', 'LIKE','%'.$slug.'%')->count();
        $suffix = $count ? $count+1 : '';
        $slug .= $suffix;
        return $slug;
    }


    public function category(){
    	return $this->belongsTo(Category::class, 'category_id')->withDefault();
    }
}
