<?php

namespace App\Http\Controllers\Pos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\Order;
use App\Models\OrderDetails;
use App\Models\OutletStock;
use Auth;
use DB;

class PosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title']= "Create Invoice";
        // logodata
        $logdata = array();
        $data['categories'] = Category::orderBy('category_id', 'asc')->get();
        return view('admin.pages.pos.crateinvoice', $data);
    }

    public function InsertPosInvoice(Request $request) {

        DB::beginTransaction();
        $data = new Order();
        $data['invoice_date']= date("Y-m-d");
        $data['outlet_id']= Auth::user()->outlet_id;
        $data['bill_vat']= $request->bill_vat;
        $data['total_bill']= $request->total_bill;
        $data['bill_type']= 'Cash';//$request->total_bill;
        $data['user_id']= Auth::user()->id;
        $data['customer_name']= $request->customer_name;
        $data['mobile_number']= $request->mobile_number;
        $data['advanceAmt']= $request->advanceAmt;
        $data['dueAmt']= $request->dueAmt;

        try {
            $data->save();
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(['status' => false, 'message' => 'Opps, Something went wrong, please try again']);
        }

        // $InvoiceId = DB::table('tbl_invoice')->insertGetId($data);
        

        $product_id= $request->product_id;
        $qnty= $request->qnty;
        $rate= $request->rate;
        $user_id= Auth::user()->id;
        if (!empty($product_id > 0)) {
            $temp = count($product_id);
            $result = array();
            for ($i = 0; $i < $temp; $i++) {
                $od_details = new OrderDetails();
                $product_data = Product::find($product_id[$i]);
                if($product_data->has_stock){
                    $product_data->has_stock->usable_qty -= $qnty[$i];
                    try {
                        $product_data->has_stock->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        return response()->json(['status' => false, 'message' => 'Opps, Something went wrong, please try again']);
                    }
                }
                
                

                // return $product_data;
                $od_details['InvoiceId'] = $data->invoice_id;
                $od_details['product_id'] = $product_id[$i];
                $od_details['qnty'] = $qnty[$i];
                $od_details['rate'] = $rate[$i];
                $od_details['sub_total'] = $rate[$i] * $qnty[$i];
                $od_details['user_id'] = $user_id;
                $od_details['price'] = $qnty[$i] * $product_data->orginal_price;

                try {
                    $od_details->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    return response()->json(['status' => false, 'message' => 'Opps, Something went wrong, please try again']);
                }
            }
            
            // DB::table('tbl_invoice_history')->insert($data2);
          
        }

        $userId = Auth::user()->id;
        DB::table('tbl_invoice_draft')->where('tbl_invoice_draft.user_id',$userId)->delete();
        DB::table('tbl_hold_history')->where('tbl_hold_history.user_id',$userId)->delete();
        DB::table('tbl_hold_history')->where('tbl_hold_history.user_id',$userId)->delete();

        DB::commit();
        echo json_encode("successfully Insert");
        
        // logodata
        // $logdata = array();
        // $logdata['user_id'] = Auth::user()->id;
        // $logdata['role_id'] = Auth::user()->role;
        // $logdata['action'] = "Insert";
        // $logdata['details'] = "User Final Created Invoice";
        // $logdata['date_time'] =date("F j, Y, g:i a");
        // $logdata['date'] = date("Y-m-d");
        // $logdata['ip'] = getHostByName(getHostName());
        // DB::table('tbl_logdata')->insert($logdata);
                    
         
        
    }


}
