<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\User;
use App\Models\Outlet;
use App\Models\Role;
use Auth;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = 'User';
        $data['users'] = User::orderBy('id','desc')->paginate(20);
        $data['outlets'] = Outlet::all();
        $data['roles'] = Role::all();
        return view('admin.pages.users', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'role' => 'required',
            'status' => 'required',
            'username' => 'required|unique:users|max:255',
        ]);

        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->username = $request->username;
        $user->password = bcrypt($request->password);
        $user->temp_password = $request->password;
        $user->role = $request->role;
        $user->status = $request->status;
        $user->outlet_id = $request->outlet_id;

        $doc = $request->file('image');
        if(isset($doc)){
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $doc, $doc_name);
            $user->photo = $doc_name;
        }

        try {
            $user->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Added');
        return redirect()->back();

    }

 
    public function update(Request $request)
    {
        $user = User::findOrFail($request->user_id);
        // dd($request);
        $request->validate([
            'name' => 'required',
            'role' => 'required',
            'username' => 'unique:users,username,'.$user->id
        ]);

        
        $user->name = $request->name;
        $user->email = $request->email;
        $user->username = $request->username;
        $user->password = bcrypt($request->password);
        $user->temp_password = $request->password;
        $user->role = $request->role;
        $user->status = $request->status;
        $user->outlet_id = $request->outlet_id;

        $doc = $request->file('image');
        if(isset($doc)){
            if (Storage::disk('public')->exists('uploads/'.$user->photo)) {
                Storage::disk('public')->delete('uploads/'.$user->photo);
            }
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $doc, $doc_name);
            $user->photo = $doc_name;
        }

        try {
            $user->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully User Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        if($user->photo){
            if (Storage::disk('public')->exists('uploads/'.$user->photo)) {
                Storage::disk('public')->delete('uploads/'.$user->photo);
            }
        }

        try {
            $user->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully User Deleted');
        return redirect()->back();
        
    }
}
