<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SubCategory;
use App\Models\Category;
use Auth;

class SubCategortController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = 'Sub Category';
        $data['categories'] = Category::all();
        $data['sub_categories'] = SubCategory::orderBy('sub_cat_id','desc')->paginate(20);
        return view('admin.pages.sub_categories', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new SubCategory();
        $data->category_id = $request->category;
        $data->sub_cat_name = $request->name;
        $data->status = $request->status;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Sub Category Added');
        return redirect()->back();

    }

 
    public function update(Request $request)
    {
        $data = SubCategory::findOrFail($request->sub_cat_id);
        $data->category_id = $request->category;
        $data->sub_cat_name = $request->name;
        $data->status = $request->status;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Sub Category Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(SubCategory $sub_category)
    {
        try {
            $sub_category->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Sub Category Deleted');
        return redirect()->back();
        
    }
}
