<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Outlet;
use App\Models\Order;
use App\Models\OrderDetails;
use Carbon\Carbon;
use PDF;

class ReportController extends Controller
{
    public function index(){
    	$data['title'] = 'Report';
    	$data['products'] = Product::all();
    	$data['outlets'] = Outlet::all();
    	return view('admin.pages.report.report_form', $data);
    }

    public function revenue_report(Request $request){
        $data['title'] = 'Revenue report';
        $data['outlet_wise'] = False;
        $data['product_wise'] = False;
        $orders = Order::orderBy('invoice_date', 'desc');
        if($request->start && $request->end){
            $start = Carbon::parse($request->start)->format('Y-m-d');
            $end = Carbon::parse($request->end)->format('Y-m-d');
            $orders = $orders->whereBetween('invoice_date', [$start, $end]);
            $data['date_show'] = ($start == $end)? $start : $start .' - '.$end;
        }
        if($request->outlet){
            $data['outlet_wise'] = True; 
            $data['outlet'] = Outlet::where('id', $request->outlet)->first();
            $orders = $orders->where('outlet_id', $request->outlet);
        }
        if($request->product){
            $data['product_wise'] = True;
            $data['product'] = Product::where('product_id', $request->product)->first();
            $order_details = OrderDetails::where('product_id', $request->product)->get()->toArray();
            $ids = array_column($order_details, 'InvoiceId');
            $orders = $orders->whereIn('invoice_id', array_unique($ids));
        }        
        $data['orders'] = $orders->get();
        $data['outlets'] = Outlet::all();               
        ///return view('admin.pages.report.print.outlet_revenue_wise_report_print', $data);
        $pdf = PDF::loadView('admin.pages.report.print.outlet_revenue_wise_report_print', $data);
        return $pdf->stream('revenue_report.pdf');
    }
}
