<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OutletStock extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'outlet_id', 'product_id', 'date','fac_rec_qty','usable_qty','waste_qty','return_qty',
        'prev_qty','created_by'
    ];

    public function outlet(){
    	return $this->belongsTo(Outlet::class, 'outlet_id');
    }

    public function product(){
    	return $this->belongsTo(Product::class, 'product_id');
    }

    public function user(){
    	return $this->belongsTo(\App\User::class, 'created_by');
    }

}
