<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $table = 'tbl_invoice';
    protected $primaryKey = 'invoice_id';
    public $timestamps = false;

    public function getInvoiceDateAttribute($date){
    	return date('d M y', strtotime($date));
    }

    public function outlet(){
    	return $this->belongsTo(Outlet::class, 'outlet_id')->withDefault();
    }

    public function user(){
    	return $this->belongsTo(\App\User::class, 'user_id')->withDefault();
    }

    public function order_details(){
    	return $this->hasMany(OrderDetails::class, 'InvoiceId');
    }
}
