<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Order;
use App\Models\OrderDetails;

class SalesController extends Controller
{
   	public function create_invoice(){
   		$data['title'] = 'Create Invoice';
   		return view('admin.pages.sales.create_invoice', $data);
   	}

   	public function get_product_data_by_item_name(Request $request){
   		if(empty($request->item_name)){
   			return response()->json(['status' => false, 'message' => 'Item Name Can not be null', 'data' => [] ]);
   		}
   		//$outlet_stock = Pro::
        $data = Product::where('product_name',$request->item_name)
          ->orWhere('product_code', $request->item_name)
          ->orWhere('product_id', $request->item_name)->get();
        if(count($data)){
        	return response()->json(['status' => true, 'message' => 'Item found', 'data' => $data ]);
        }
        
    }
    protected function rePrintInvoice(Request $request){
      /*return Order::where('invoice_id', $request->invoice_id)
      ->with('order_details')->with('product')->get();*/

      return Order::where('invoice_id', $request->invoice_id)->with(
        ['outlet','order_details' => function($query) use($request){
            $query->with(['product'=>function($query) use($request){

            }]);
        }])->get();
    }
}
