<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\OutletStock;
use App\Models\Product;
use App\Models\Outlet;
use Auth;
use DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use Maatwebsite\Excel\Facades\Excel;
use Input;


class OutletDailyStockController extends Controller
{
    public function index(Request $request){     
    //dd($request);   
    	$data['title'] = "Outlet Wise Daily Stock";
    	$outlet_stocks = OutletStock::orderBy('id', 'desc');
        if(Auth::user()->role != 1){
            $outlet_stocks = $outlet_stocks->where('outlet_id', Auth::user()->outlet_id);
        }

        if($request->start && $request->end){
            $start = date('Y-m-d', strtotime($request->start));
            $end = date('Y-m-d', strtotime($request->end));
            $outlet_stocks = $outlet_stocks->whereBetween('date', [$start, $end]);
        }
        if($request->outlet){
            $outlet_stocks = $outlet_stocks->where('outlet_id', $request->outlet);
        }
        $data['request'] = $request;
        $data['outlet_stocks'] = $outlet_stocks->paginate(20);

    	
        if(Auth::user()->role =='1'){
            $data['outlets'] = Outlet::all();
        }else{
            $data['outlets'] = Outlet::where('id', Auth::user()->outlet_id)->get();
        }
        //dd($outlet_stocks);
    	$data['products'] = Product::all();
    	return view('admin.pages.stock.daily_stock', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {        
        //$data = new OutletStock();
        //dd( $request->base_unit);
        $outlet_id = '';

        if(Auth::user()->role == 1){
            $outlet_id = $request->outlet_id;
        }else{
            $outlet_id = Auth::user()->outlet_id;
        }
        $is_check = OutletStock::where('date', date('Y-m-d'))->where('product_id', $request->product_id)->where('outlet_id', $outlet_id)->first();
        $last_data = OutletStock::orderBy('id','desc')->where('product_id', $request->product_id)->where('outlet_id', $outlet_id)->first();

        /*if(!empty($is_check)){
            toastr()->warning('Item already added this date, please try again');
            return redirect()->back();
        }*/
        //$data->prev_qty = ($last_data)? $last_data->usable_qty : 0;
        //$stock_data = new OutletStock();
        $outlet_stock_id = '';
        if($last_data){
            $stock_data['usable_qty'] = $last_data->usable_qty + $request->fac_rec_qty;
            $stock_data['fac_rec_qty'] = $last_data->fac_rec_qty + $request->fac_rec_qty;
            $outlet_stock_id =  $last_data->id;
        }else{
            $stock_data['usable_qty'] =  $request->fac_rec_qty;
            $stock_data['fac_rec_qty'] = $request->fac_rec_qty;
        }        
        $stock_data['outlet_id'] = $outlet_id;
        $stock_data['product_id'] = $request->product_id;
        $stock_data['date'] = date('Y-m-d');       
        $stock_data['created_by'] = Auth::user()->id;
       
        try {
            $stock_created = OutletStock::updateOrCreate(['id' => $outlet_stock_id ], $stock_data);

            //$last_data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Added');
        return redirect()->back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        // dd($request);
        $data = OutletStock::find($request->outlet_stocks_id);        
        $data->usable_qty = $data->usable_qty + ($request->old_waste_qty + $request->old_return_qty);
        $data->save();

        $data->waste_qty = $request->waste_qty;
        $data->return_qty = $request->return_qty;
        //dd($data);
        // if(Auth::user()->role == 1){
        //     $data->outlet_id = $request->outlet_id;
        // }else{
        //     $data->outlet_id = Auth::user()->outlet_id;
        // }
        // $data->product_id = $request->product_id;
        // $data->fac_rec_qty = $request->fac_rec_qty;
        //DB::table('outlet_stocks')->where('id', $request->outlet_stocks_id)->update(array('usable_qty' => DB::raw('usable_qty + ' .$total_requested_days)));

        $data->usable_qty = $data->usable_qty - ($request->waste_qty + $request->return_qty);
       
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Updated');
        return redirect()->back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = OutletStock::find($id);
        try {
            $data->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Product Deleted');
        return redirect()->back();
    }
    /** ABU TAHER
    /* Upload a Daily stock file for products in specific outlet  
    /*
    */
     protected function uploadDailyStockFile(Request $request)
    {
        //$file = file($request->stock_file->getRealPath());
        $inputFileName = $request->stock_file->getRealPath();
        $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReaderForFile($inputFileName);
        $reader->setReadDataOnly(TRUE);
        $spreadsheet = $reader->load($inputFileName);

        $worksheet = $spreadsheet->getActiveSheet();
        //print_r($worksheet->toArray());
        $counter = 1;
        foreach ($worksheet->toArray() as $worksheet) {
            if($counter != 1){ 
                if( $worksheet[2] ){
                    $stock_data['outlet_id'] = $request->outlet_id;
                    $stock_data['product_id'] = $worksheet[0];
                    $stock_data['fac_rec_qty'] = $worksheet[2];                    
                    
                    $out_let_stock = OutletStock::where('product_id', $worksheet[0])->where('outlet_id', $request->outlet_id)->get();

                    if(count($out_let_stock)){                       
                        $previous_fac_rec_qty = $out_let_stock[0]->fac_rec_qty; 
                        $stock_data['fac_rec_qty'] =  $previous_fac_rec_qty + $stock_data['fac_rec_qty']; 
                        $stock_data['usable_qty'] = $out_let_stock[0]->usable_qty + $worksheet[2];    
                        try {      
                            $stock_data['date'] = date('Y-m-d');                        
                            OutletStock::where('product_id', $worksheet[0])->where('outlet_id', $request->outlet_id)->update($stock_data);
                        }catch (Exception $e) {
                            toastr()->error($e->message());
                                //return redirect()->back();
                        }                                    
                                            
                    }else{                        
                        $stock_data['usable_qty'] = $worksheet[2];
                        $stock_data['date'] = date('Y-m-d');       
                        $stock_data['created_by'] = Auth::user()->id;
                        try {
                            $stock_created = OutletStock::Create($stock_data);
                        }catch (Exception $e) {
                            toastr()->error($e->message());
                                //return redirect()->back();
                        }
                    }
                }                
            }
            $counter = $counter + 1;
        }
        toastr()->success('Successfully Stock Updated');
        return redirect()->back(); 
    }
}
