<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\OrderDetails;
use App\Models\Outlet;
use Auth;

class OrderController extends Controller
{
    public function index(Request $request){
        $data['title'] = "Order";
        $data['request'] = $request;
        $orders = Order::orderBy('invoice_id','desc')->where('invoice_date', date('Y-m-d'));
        $data['outlets'] = Outlet::all();
        if($request->start && $request->end){
            $start = date('Y-m-d', strtotime($request->start));
            $end = date('Y-m-d', strtotime($request->end));
            $orders = $orders->whereBetween('invoice_date', [$start, $end]);
        }
        if($request->outlet){
            $orders = $orders->where('outlet_id', $request->outlet);
        }
        if(Auth::user()->outlet_id){
            $orders = $orders->where('outlet_id', Auth::user()->outlet_id);
        }        
        $data['orders'] = $orders->paginate();
        return view('admin.pages.order.order_list', $data);
    }

    public function order_details($id){
    	$data['title'] = "Order Details";
    	$data['order'] = Order::findOrFail($id);
    	$data['order_details'] = OrderDetails::where('InvoiceId',$data['order']->invoice_id)->get();
    	return view('admin.pages.order.order_details', $data);
    }
}
